// Parameters related to POF training
// Future work: Use User_parameter.json & argparse in python code

#ifndef USER_PARAMETER_H
#define USER_PARAMETER_H

#include <string>
#include <stdio.h>
#include <stdarg.h>
#include <iostream>
#include <memory>
using namespace std;

const int n_label = 1;
const int MAX_batch_size = 4096;
const int MAX_n_internal_test_case = 1000000;
const int MAX_n_class = 2;
const int MAX_n_rank = 2;

struct User_parameter {
	int n_rank = 0;
	double th = 0.;
	double beta = 0.;
	double min_loss = 3000;
	double lambda = 0.;
	double xi = 0.;
	double context[n_label][MAX_n_rank] = {}; //individual
};

void init_userparameter(struct User_parameter** p_user_parameter);
void print_userparameter(struct User_parameter* user_parameter);
void set_userparameter(
	int n_rank,
	double th,
	double beta,
	double min_loss,
	double lambda,
	double xi,
	double context_list[],
	struct User_parameter* user_parameter
);
void update_xi(
	double xi,
	struct User_parameter* user_parameter
);
void update_min_loss(
	double min_loss,
	struct User_parameter* user_parameter
);

#endif